<?php include_once('includes/url.inc.php'); ?> 
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, minimum-scale=1.0, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/images/favicon.ico" type="image/x-icon"> 
    <title>Experience the Best Luxury Houseboats in Kollam</title>
 
    <!-- All Stylesheets -->
    <?php $folder='root'; include_once('includes/stylesheets.inc.php'); ?> 
    <style>
        .disc__list__extra li {padding-left: 1.25rem;position: relative;color: #000000;}
        .disc__list__extra li::before {content: "";display: block;width: 9px;height: 9px; position: absolute;top: 0.5rem;left: 0%;background-color: #F7A800;transform: rotate(45deg);}
        .row li{margin-bottom: .5rem;}
        .accordion .accordion-item {border-radius: 1.125rem;border: 1px solid #707070 !important;}
        .accordion .accordion-item .accordion-button {background: #F1F3F6; color: var(--brand);font-size: 1.1875rem;font-weight: 700;min-height: 4rem;}
        .accordion .accordion-item .accordion-button:not(.collapsed) {background-color: #F1F3F6;}
        .accordion .accordion-item .accordion-body {background-color: #F1F3F6;}
        /* .crad__houseboat{min-height: 32rem;} */
        @media (min-width: 1800px) {.container-fluid {max-width: 1800px;margin-left: auto;margin-right: auto;}}
        .honeymoon__wrapper .container-fluid { padding: 5rem 0; }
        @media (min-width: 1200px) { .honeymoon__wrapper .container-fluid { padding: 8rem 0; } }
        @media (min-width: 1600px) { .honeymoon__wrapper .container-fluid { padding: 12rem 0; } }
        .honeymoon__wrapper .gradient__bg {background-image: linear-gradient(90deg, #003E6E, rgba(84, 84, 84, 0));}
        .disc__list__extra.row { padding-left: .625rem; }
        @media(max-width:767px) {
            .honeymoon__wrapper .gradient__bg { background-image: linear-gradient(90deg, #003E6E, #003E6E);opacity: .75; }
        }
        .whyChooseCarousel .owl-dots .owl-dot.active { background-color: #fff !important; }
    </style>
</head>
<body class="position-relative" data-bs-spy="scroll" data-bs-target="#navbarspy"> 

    <!-- Preloader, Main Navigation Menu --> 
    <?php $folder='inside'; include_once('includes/header.inc.php'); ?> 

    <!-- Header Wrapper Start --> 
    <div class="page__header py-5 position-relative">
        <img 
            src="<?php echo $base_url;?>assets/images/home/header-bg-image.webp"
            srcset="<?php echo $base_url;?>assets/images/home/header-bg-image-500.webp 500w, 
            <?php echo $base_url;?>assets/images/home/header-bg-image-1000.webp 992w, 
            <?php echo $base_url;?>assets/images/home/header-bg-image.webp 1200w" 
            width="1920" height="222"
            alt="Experience the Best Luxury Houseboats in Kollam"
            class="img-fluid position-absolute top-0 start-0 z-1 h-100 w-100 object-cover"
        >
        <div class="position-absolute top-0 start-0 w-100 h-100 z-2" style="background-color: rgba(0, 0, 0, 0.635);"></div>
        <div class="container position-relative z-2 py-3 pt-5 pb-sm-5 mb-md-5 pt-5">
            <h1 class="h1 text-center text-white mb-0 mt-xl-5 pt-4 pt-lg-5">
                Experience the Best Luxury Houseboats in Kollam
            </h1> 
        </div><!--.//container-->
    </div>
    <!-- Header Wrapper End -->  

    <!--Discover the charm Section Start -->
    <section class="py-5">
        <div class="container-fluid"> 
            <div class="row g-4 g-lg-5 align-items-center pt-3 pt-lg-4">
                <div class="col-lg-5">
                    <figure class="mb-0">
                        <img 
                            src="assets/images/luxury-houseboat-kollam-ashtamudi/ultimate-kollam-boating-circuit.webp" 
                            class="img-fluid w-100"
                            width="712" height="436"
                            alt="From Ashtamudi to Munroe Island and Sambranikodi: The Ultimate Kollam Boating Circuit "
                        > 
                    </figure>
                </div><!--//.col-->
                <div class="col-lg-7">
                    <h2 class="text-primary fw-semibold h3 mb-3 mb-lg-4 text-center text-lg-start">
                        From Ashtamudi to Munroe Island and Sambranikodi: The Ultimate Kollam Boating Circuit 
                    </h2>
                    <p class="text-dark text-center text-lg-start">
                        There’s something soul-stirring about gliding across the Ashtamudi backwaters—where the lake stretches like a silver ribbon through coconut groves and sleepy villages. Houseboating in Ashtamudi offers a rare blend of serenity, scenic charm, and cultural immersion. Whether you're seeking a romantic escape, a peaceful solo retreat, or a joyful family journey, every moment on these waters feels timeless and transformative.
                    </p>
                </div><!--//.col-->
            </div><!--//.row-->
            <div class="row g-4 g-lg-5 align-items-center mt-3 mt-lg-4">
                <div class="col-lg-5 order-lg-2">
                    <figure class="mb-0">
                        <img 
                            src="assets/images/luxury-houseboat-nileshwar-kasargod/choose-luxury-houseboat-nileshwar.webp" 
                            class="img-fluid w-100"
                            width="712" height="472"
                            alt="Top Attractions to Explore While Houseboating in Ashtamudi Backwaters"
                        > 
                    </figure>
                </div><!--//.col-->
                <div class="col-lg-7 order-lg-1">
                    <h2 class="text-primary fw-semibold h3 mb-3 mb-lg-4 text-center text-lg-start">
                        Top Attractions to Explore While Houseboating in Ashtamudi Backwaters
                    </h2>
                    <ul class="disc__list__extra d-flex flex-column gap-1">
                        <li class="mb-0">Chinese fishing nets at Neendakara</li>
                        <li class="mb-0">Munroe Island’s canals and birdwatching spots</li>
                        <li class="mb-0">Traditional village life and local livelihoods</li>
                        <li class="mb-0">Sunset over Ashtamudi Lake</li>
                        <li class="mb-0">Thevally Palace</li>
                        <li class="mb-0">Historic Kollam canal network</li>
                        <li class="mb-0">Lush coconut groves and mangrove forests</li>
                    </ul>
                </div><!--//.col-->
            </div><!--//.row-->
        </div><!--//.container-->
    </section>
    <!--Discover the charm Section End --> 

    <!--Best Time to Visit Section Start -->
    <section class="" style="background: rgba(0, 61, 108, 0.1);">
        <div class="container px-md-5">
            <h2 class="text-primary fw-semibold h3 py-5 text-center">Best Time to Visit Kollam for Boating </h2> 
            <div class="row g-3 pb-5">
                <div class="col-lg-4 col-md-4 col-12 d-flex">
                   <div class="best__card bg-white rounded-4 p-4" style="border: 2px solid rgba(112, 112, 112, 0.5);">
                        <h3 class="text-primary lead fw-bold">October to March </h3>
                        <p class="text-dark">Best weather, perfect for long overnight cruises</p>
                   </div>
                </div><!--//.col-->
                <div class="col-lg-4 col-md-4 col-12 d-flex">
                   <div class="best__card bg-white rounded-4 p-4" style="border: 2px solid rgba(112, 112, 112, 0.5);">
                        <h3 class="text-primary lead fw-bold">June to September</h3>
                        <p class="text-dark">Monsoon lovers rejoice; the rains paint everything green</p>
                   </div>
                </div><!--//.col-->
                <div class="col-lg-4 col-md-4 col-12 d-flex">
                   <div class="best__card bg-white rounded-4 p-4" style="border: 2px solid rgba(112, 112, 112, 0.5);">
                        <h3 class="text-primary lead fw-bold">April to May</h3>
                        <p class="text-dark">Sunny skies and seasonal deals on all houseboats</p>
                   </div>
                </div><!--//.col-->
            </div><!--//.row-->
        </div><!--//.container-->
    </section>
    <!--Best Time to Visit Section End --> 

    <!--Luxury Houseboat Options Section Start --> 
    <section class="py-5" style="background: #003D6C;">
        <div class="container-fluid">
            <h2 class="h2 text-white fw-bold text-center pb-4">
                Discover Top Luxury Options in Houseboat
            </h2>
            <div class="owl-carousel whyChooseCarousel ">
                <div class="py-5 px-3 px-sm-5 px-lg-4 position-relative d-flex w-100">
                    <img 
                        src="assets/images/luxury-houseboat-nileshwar-kasargod/luxury-houseboat.webp" 
                        class="img-fluid position-absolute top-0 start-0 w-100 h-100 object-cover z-0" 
                        width="576" height="252" 
                        alt="Luxury Houseboat"
                    >
                    <div class="position-absolute top-0 start-0 w-100 h-100 z-2" style="background-color: #0000009A; opacity:1"></div>
                    <div class="crad__houseboat z-index w-100">
                        <h3 class="h3 text-white fw-bold mb-3 text-center">Luxury <span class="d-block">Houseboat</span></h3>
                        <div class="mt-4 text-center">
                            <a href="https://veneziakeralahouseboat.com/luxury-houseboats.php" class="btn btn-primary orange fw-bold height rounded-pill px-4" aria-label="VIEW DETAILS">
                                VIEW DETAILS
                            </a>
                        </div>
                    </div>
                </div>
                <div class="py-5 px-3 px-sm-5 px-lg-4 position-relative d-flex w-100">
                    <img 
                        src="assets/images/luxury-houseboat-nileshwar-kasargod/super-luxury-houseboat.webp" 
                        class="img-fluid position-absolute top-0 start-0 w-100 h-100 object-cover z-0" 
                        width="576" height="252" 
                        alt="Super Luxury Houseboat"
                    >
                    <div class="position-absolute top-0 start-0 w-100 h-100 z-2" style="background-color: #0000009A; opacity:1"></div>
                    <div class="crad__houseboat z-index w-100">
                        <h3 class="h3 text-white fw-bold mb-3 text-center">Super <span class="d-block">Luxury Houseboat</span></h3>
                        <div class="mt-4 text-center">
                            <a href="https://veneziakeralahouseboat.com/super-luxury-houseboat.php" class="btn btn-primary orange fw-bold height rounded-pill px-4" aria-label="VIEW DETAILS">
                                VIEW DETAILS
                            </a>
                        </div>
                    </div>
                </div>
                <div class="py-5 px-3 px-sm-5 px-lg-4 position-relative d-flex w-100">
                    <img 
                        src="assets/images/luxury-houseboat-nileshwar-kasargod/semi-luxury-houseboat.webp" 
                        class="img-fluid position-absolute top-0 start-0 w-100 h-100 object-cover z-0" 
                        width="576" height="252" 
                        alt="Semi Luxury Houseboat"
                    >
                    <div class="position-absolute top-0 start-0 w-100 h-100 z-2" style="background-color: #0000009A; opacity:1"></div>
                    <div class="crad__houseboat z-index w-100">
                        <h3 class="h3 text-white fw-bold mb-3 text-center">Semi <span class="d-block">Luxury Houseboat</span></h3>
                        <div class="mt-4 text-center">
                            <a href="https://veneziakeralahouseboat.com/semi-luxury-houseboats.php" class="btn btn-primary orange fw-bold height rounded-pill px-4" aria-label="VIEW DETAILS">
                                VIEW DETAILS
                            </a>
                        </div>
                    </div>
                </div>
            </div><!--//.carousel-->
        </div>
    </section>
    <!--Luxury Houseboat Options Section End --> 

    <!--Discover the charm Section Start -->
    <section class="py-5">
        <div class="container-fluid"> 
            <div class="row g-4 g-lg-5 align-items-center pt-3 pt-lg-4">
                <div class="col-lg-5">
                    <figure class="mb-0">
                        <img 
                            src="assets/images/luxury-houseboat-kollam-ashtamudi/must-visit-places.webp" 
                            class="img-fluid w-100"
                            width="712" height="436"
                            alt="Beyond the Backwaters: Must-Visit Places Near Ashtamudi Lake"
                        > 
                    </figure>
                </div><!--//.col-->
                <div class="col-lg-7">
                    <h2 class="text-primary fw-semibold h3 mb-3 mb-lg-4 text-center text-lg-start">
                        Beyond the Backwaters: Must-Visit Places Near Ashtamudi Lake
                    </h2>
                   <ul class="disc__list__extra d-flex flex-column gap-2">
                        <li>Thangassery Lighthouse</li>
                        <li>Varkala Beach & Cliff </li>
                        <li>Thenmala Eco-tourism & Jatayu Earth Center</li>
                        <li>Palaruvi Waterfalls</li>
                   </ul>
                </div><!--//.col-->
            </div><!--//.row-->
            <div class="row g-4 g-lg-5 align-items-center mt-3 mt-lg-4">
                <div class="col-lg-5 order-lg-2">
                    <figure class="mb-0">
                        <img 
                            src="assets/images/luxury-houseboat-kollam-ashtamudi/boating-through-munroe-island.webp" 
                            class="img-fluid w-100"
                            width="712" height="472"
                            alt="Boating Through Munroe Island – The Soul of Ashtamudi Backwaters"
                        > 
                    </figure>
                </div><!--//.col-->
                <div class="col-lg-7 order-lg-1">
                    <h2 class="text-primary fw-semibold h3 mb-3 mb-lg-4 text-center text-lg-start">
                        Boating Through Munroe Island – The Soul of Ashtamudi Backwaters
                    </h2>
                    <p class="text-dark">
                        Munroe Island, or Mundrothuruth, lies where the Ashtamudi Lake gently meets the Kallada River—a peaceful maze of canals, lagoons, and coconut groves. This island offers a rare window into authentic Kerala village life, away from the noise of tourist trails. Whether you’re canoeing through shaded backwater alleys or kayaking with a local guide, every turn reveals something timeless. It’s not just a detour—it’s the heartbeat of the backwaters, quiet and unforgettable.
                    </p>
                </div><!--//.col-->
            </div><!--//.row-->
            <div class="row g-4 g-lg-5 align-items-center mt-3 mt-lg-4">
                <div class="col-lg-5">
                    <figure class="mb-0">
                        <img 
                            src="assets/images/luxury-houseboat-kollam-ashtamudi/top-experiences-munroe-island.webp" 
                            class="img-fluid w-100"
                            width="712" height="436"
                            alt="Top Experiences in Munroe Island"
                        > 
                    </figure>
                </div><!--//.col-->
                <div class="col-lg-7">
                    <h2 class="text-primary fw-semibold h3 mb-3 mb-lg-4 text-center text-lg-start">
                        Top Experiences in Munroe Island
                    </h2>
                   <ul class="disc__list__extra d-flex flex-column gap-2">
                        <li>Canoeing through narrow backwater canals</li>
                        <li>Kayaking across scenic, winding lagoons</li>
                        <li>Birdwatching – spot herons, kingfishers, and egrets</li>
                        <li>Watch toddy tapping and coir weaving</li>
                        <li>Sunrise and sunset backwater cruises</li>
                        <li>Explore ancient mangrove routes with local guides</li>
                        <li>Glide past traditional village life in real time</li>
                   </ul>
                </div><!--//.col-->
            </div><!--//.row-->
        </div><!--//.container-->
    </section>
    <!--Discover the charm Section End --> 

    <!--Explore Alleppey Section Start --> 
    <section class="py-5" style="background: #003D6C;">
        <div class="container-fluid">
            <h2 class="h2 text-white fw-bold text-center pb-4">
                Uncover the Best Backwater Escapes in Alleppey
            </h2>
            <div class="owl-carousel whyChooseCarousel ">
                <div class="py-5 px-3 px-sm-5 px-lg-4 position-relative d-flex w-100">
                    <img 
                        src="assets/images/luxury-houseboat-nileshwar-kasargod/luxury-houseboat.webp" 
                        class="img-fluid position-absolute top-0 start-0 w-100 h-100 object-cover z-0" 
                        width="576" height="252" 
                        alt="Luxury Houseboat"
                    >
                    <div class="position-absolute top-0 start-0 w-100 h-100 z-2" style="background-color: #0000009A; opacity:1"></div>
                    <div class="crad__houseboat z-index w-100">
                        <h3 class="h3 text-white fw-bold mb-3 text-center">Luxury <span class="d-block">Houseboat</span></h3>
                        <div class="mt-4 text-center">
                            <a href="https://veneziakeralahouseboat.com/best-luxury-houseboats-in-alleppey.php" class="btn btn-primary orange fw-bold height rounded-pill px-4" aria-label="VIEW DETAILS">
                                VIEW DETAILS
                            </a>
                        </div>
                    </div>
                </div>
                <div class="py-5 px-3 px-sm-5 px-lg-4 position-relative d-flex w-100">
                    <img 
                        src="assets/images/luxury-houseboat-nileshwar-kasargod/semi-luxury-houseboat.webp" 
                        class="img-fluid position-absolute top-0 start-0 w-100 h-100 object-cover z-0" 
                        width="576" height="252" 
                        alt="Semi Luxury Houseboat"
                    >
                    <div class="position-absolute top-0 start-0 w-100 h-100 z-2" style="background-color: #0000009A; opacity:1"></div>
                    <div class="crad__houseboat z-index w-100">
                        <h3 class="h3 text-white fw-bold mb-3 text-center">Semi <span class="d-block">Luxury Houseboat</span></h3>
                        <div class="mt-4 text-center">
                            <a href="https://veneziakeralahouseboat.com/super-luxury-houseboats-alleppey-kerala.php" class="btn btn-primary orange fw-bold height rounded-pill px-4" aria-label="VIEW DETAILS">
                                VIEW DETAILS
                            </a>
                        </div>
                    </div>
                </div> 
                <div class="py-5 px-3 px-sm-5 px-lg-4 position-relative d-flex w-100">
                    <img 
                        src="assets/images/luxury-houseboat-nileshwar-kasargod/super-luxury-houseboat.webp" 
                        class="img-fluid position-absolute top-0 start-0 w-100 h-100 object-cover z-0" 
                        width="576" height="252" 
                        alt="Super Luxury Houseboat"
                    >
                    <div class="position-absolute top-0 start-0 w-100 h-100 z-2" style="background-color: #0000009A; opacity:1"></div>
                    <div class="crad__houseboat z-index w-100">
                        <h3 class="h3 text-white fw-bold mb-3 text-center">Super <span class="d-block">Luxury Houseboat</span></h3>
                        <div class="mt-4 text-center">
                            <a href="https://veneziakeralahouseboat.com/luxury-houseboats-alleppey-kerala.php" class="btn btn-primary orange fw-bold height rounded-pill px-4" aria-label="VIEW DETAILS">
                                VIEW DETAILS
                            </a>
                        </div>
                    </div>
                </div>
                
            </div><!--//.carousel-->
        </div>
    </section>
    <!--Explore Alleppey Section End --> 

    <!--Top Attractions Section Start -->
    <section class="py-5">
        <div class="container-fluid"> 
            <div class="row g-4 g-lg-5 align-items-center pt-3 pt-lg-4">
                <div class="col-lg-5 order-lg-2">
                    <figure class="mb-0">
                        <img 
                            src="assets/images/luxury-houseboat-kollam-ashtamudi/natural-standing-spot-river.webp" 
                            class="img-fluid w-100"
                            width="712" height="472"
                            alt="Houseboat in Kollam or Alleppey? Find Out Which One Suits You Best"
                        > 
                    </figure>
                </div><!--//.col-->
                <div class="col-lg-7 order-lg-1">
                    <h2 class="text-primary fw-semibold h3 mb-3 mb-lg-4">
                        Houseboat in Kollam or Alleppey? Find Out Which One Suits You Best
                    </h2>
                    <p class="text-dark">
                        If you're looking for a classic houseboat experience with plenty of options, vibrant activity, and easy accessibility, Alleppey is the perfect fit. But if you prefer a quieter, more laid-back escape surrounded by serene backwaters and authentic village life, Kollam offers a more peaceful alternative. Your ideal choice depends on whether you crave variety and buzz—or solitude and charm.
                    </p>
                </div><!--//.col-->
            </div><!--//.row-->
            <div class="row g-4 g-lg-5 align-items-center mt-5">
                <div class="col-lg-5">
                    <figure class="mb-0">
                        <img 
                            src="assets/images/luxury-houseboat-kollam-ashtamudi/ultimate-kollam-boating-circuit.webp" 
                            class="img-fluid w-100"
                            width="712" height="436"
                            alt="Explore Sambranikodi – A Peaceful Gem for Boating in Kollam with a Natural Standing Spot in the River"
                        > 
                    </figure>
                </div><!--//.col-->
                <div class="col-lg-7">
                    <h2 class="text-primary fw-semibold h3 mb-3 mb-lg-4 text-center text-lg-start">
                        Explore Sambranikodi – A Peaceful Gem for Boating in Kollam with a Natural Standing Spot in the River
                    </h2>
                    <p class="text-dark text-center text-lg-start">
                        Just a short drive from Ashtamudi Lake, Sambranikodi is a rising eco-tourism gem nestled along the serene banks of the Kallada River. This peaceful riverside destination is ideal for a half-day excursion before or after your boating journey. Surrounded by mangroves, village trails, and calm waters, Sambranikodi offers a quiet refuge for nature enthusiasts, photographers, and families looking to relax in an untouched natural setting.
                    </p>
                </div><!--//.col-->
            </div><!--//.row-->
        </div><!--//.container-->
    </section>
    <!--Top Attractions Section End --> 
    
    <!--Sambranikodi Special Section Start --> 
    <section class="py-5" style="background: rgba(0, 61, 108, 0.1);">
        <div class="container-fluid">
            <h2 class="text-primary fw-semibold h3 text-center mb-4 mb-lg-5">What Makes Sambranikodi Special?</h2> 
            <div class="bg-white rounded-4 p-5">
                <ul class="row g-0 row-cols-lg-2 row-cols-md-2 row-cols-1 text-dark">
                    <li><b>Natural Standing Spot in the Middle of the River</b></li>
                    <li> A shallow, sandy patch allows visitors to stand safely midstream—perfect for photos, reflection, and a one-of-a-kind river experience</li>
                    <li><b>Boating and Canoeing</b></li>
                    <li>Enjoy scenic rides through tranquil mangrove-lined waterways</li>
                    <li><b>Untouched Natural Beauty</b></li>
                    <li>A less-crowded spot ideal for peaceful nature walks</li>
                    <li><b>Stunning Sunrise and Sunset Views</b></li>
                    <li>Capture the magic of golden reflections on the river</li>
                    <li><b>Family-friendly Trails</b></li>
                    <li>Light trekking paths and spaces perfect for kids and nature walks</li>
                    <li><b>Traditional Fishing Culture</b></li>
                    <li>Witness local fishermen using age-old, sustainable techniques</li>
                    <li><b>Ideal for Yoga and Meditation</b></li>
                    <li>Quiet riverbanks offer a serene space to reconnect with yourself</li>
                </ul>
            </div>
            <div class="row g-4 g-lg-5 align-items-center mt-4 mt-lg-5">
                <div class="col-lg-5 order-lg-2">
                    <figure class="mb-0">
                        <img 
                            src="assets/images/luxury-houseboat-kollam-ashtamudi/luxury-houseboat-kollam.webp" 
                            class="img-fluid w-100"
                            width="712" height="472"
                            alt="Book Your Luxury Houseboat in Kollam"
                        > 
                    </figure>
                </div><!--//.col-->
                <div class="col-lg-7 order-lg-1">
                    <h2 class="text-primary fw-semibold h3 mb-3 mb-lg-4 text-center text-lg-start">
                        Book Your Luxury Houseboat in Kollam
                    </h2>
                    <p class="text-dark text-center text-lg-start">
                        Drift into the heart of Kerala’s backwaters with a luxury houseboat escape on Ashtamudi Lake. Every cruise blends scenic beauty, local charm, and unmatched comfort—perfect for couples, families, or anyone craving stillness and connection. To reserve your journey, simply book through the website or reach out via phone or WhatsApp. The lake is waiting—slow down, step aboard, and let it unfold.
                    </p>
                    <div class="mt-4 text-center text-lg-start">
                        <a href="contact.php" class="btn btn-primary orange fw-bold height rounded-pill px-4">
                            CONTACT US
                        </a>
                    </div>
                </div><!--//.col-->
            </div><!--//.row-->
        </div><!--//.container-->
    </section>
    <!--Sambranikodi Special Section End --> 

    <!-- FAQ’S section Start -->
    <section class="py-5">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-4">
                    <h2 class="h2 text-primary fw-bold text-center text-lg-start">FAQs</h2>         
                </div>
                <div class="col-lg-8">
                    <div class="accordion accordion-flush mt-3 mt-lg-4 mx-auto" id="accordionFaqe">
                        <div class="accordion-item">
                            <h3 class="accordion-header" id="typical">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#trip" aria-expanded="false" aria-controls="trip">
                                    How can I book a houseboat in Ashtamudi Lake?
                                </button>
                            </h3>
                            <div id="trip" class="accordion-collapse collapse" aria-labelledby="typical" data-bs-parent="#accordionFaqe">
                                <div class="accordion-body">
                                    <p>You can book directly through the website, send us a WhatsApp message, or call our team for personalized assistance. We offer easy, secure online booking with flexible customisation options.</p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h3 class="accordion-header" id="these">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flushThese" aria-expanded="false" aria-controls="flushThese">
                                    Is boating available at Sambranikodi?
                                </button>
                            </h3>
                            <div id="flushThese" class="accordion-collapse collapse" aria-labelledby="these" data-bs-parent="#accordionFaqe">
                                <div class="accordion-body">
                                    <p>Yes, boating and canoe rides are available at Sambranikodi, especially during the early morning and late afternoon. It’s a peaceful, lesser-known spot where you can enjoy nature without the crowds, making it ideal for families and photographers.</p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h3 class="accordion-header" id="all-inclusive">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#fare" aria-expanded="false" aria-controls="fare">
                                    What makes a luxury houseboat in Ashtamudi unique?
                                </button>
                            </h3>
                            <div id="fare" class="accordion-collapse collapse" aria-labelledby="all-inclusive" data-bs-parent="#accordionFaqe">
                                <div class="accordion-body">
                                    <p>
                                        Luxury houseboats in Ashtamudi combine upscale amenities with a peaceful, uncrowded environment. You’ll enjoy panoramic views, curated interiors, private chefs, and a serene backwater setting that's less commercial than Alleppey.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item ">
                            <h3 class="accordion-header" id="customize">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#route" aria-expanded="false" aria-controls="route">
                                    Is Munroe Island worth visiting?
                                </button>
                            </h3>
                            <div id="route" class="accordion-collapse collapse" aria-labelledby="customize" data-bs-parent="#accordionFaqe">
                                <div class="accordion-body">
                                    <p> Absolutely. Munroe Island offers a glimpse into authentic Kerala life, with peaceful canals, traditional village scenes, and opportunities for canoeing, kayaking, and birdwatching. It’s a soulful escape just minutes from your houseboat route.</p> 
                                </div>
                            </div>
                        </div> 
                        <div class="accordion-item ">
                            <h3 class="accordion-header" id="dietary">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#houseboats" aria-expanded="false" aria-controls="houseboats">
                                    What makes houseboats in Kollam different from those in Alleppey?
                                </button>
                            </h3>
                            <div id="houseboats" class="accordion-collapse collapse" aria-labelledby="dietary" data-bs-parent="#accordionFaqe">
                                <div class="accordion-body">
                                    <p>Houseboat in Kollam offer a quieter, more authentic experience compared to the tourist-heavy routes of Alleppey. You’ll cruise through serene backwaters, untouched mangroves, and peaceful village landscapes that showcase Kerala’s natural beauty and traditional life.</p> 
                                </div>
                            </div>
                        </div> 
                        <div class="accordion-item ">
                            <h3 class="accordion-header" id="collapseH007">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse007" aria-expanded="false" aria-controls="collapse007">
                                    Is boating in Kollam safe for children and elderly travelers?
                                </button>
                            </h3>
                            <div id="collapse007" class="accordion-collapse collapse" aria-labelledby="collapseH007" data-bs-parent="#accordionFaqe">
                                <div class="accordion-body">
                                    <p>
                                        Yes, boating in Kollam is generally safe and well-managed. Most houseboats offer safety gear, attentive staff, and calm cruising speeds, making it suitable for all age groups.</p> 
                                </div>
                            </div>
                        </div> 
                        <div class="accordion-item ">
                            <h3 class="accordion-header" id="collapseH008">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse008" aria-expanded="false" aria-controls="collapse008">
                                    How can I book Munroe Island kayaking or canoeing packages?
                                </button>
                            </h3>
                            <div id="collapse008" class="accordion-collapse collapse" aria-labelledby="collapseH008" data-bs-parent="#accordionFaqe">
                                <div class="accordion-body">
                                    <p>You can book directly through the website or get in touch via phone or WhatsApp. Guided kayaking and canoeing packages are available with customizable timings and tour options based on your preferences and availability.</p> 
                                </div>
                            </div>
                        </div> 
                        <div class="accordion-item ">
                            <h3 class="accordion-header" id="collapseH009">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse009" aria-expanded="false" aria-controls="collapse009">
                                    How do I reach Sambranikodi from Ashtamudi or Munroe Island?
                                </button>
                            </h3>
                            <div id="collapse009" class="accordion-collapse collapse" aria-labelledby="collapseH009" data-bs-parent="#accordionFaqe">
                                <div class="accordion-body">
                                    <p>
                                        Sambranikodi is easily accessible by road and located just a short drive from both Ashtamudi Lake and Munroe Island. It’s an ideal stopover if you’re exploring Kollam’s backwaters and want to enjoy a quiet riverside picnic or a quick boating experience.
                                        </p> 
                                </div>
                            </div>
                        </div> 
                    </div><!--.//accordion--> 
                </div><!--.//col--> 
            </div>
        </div><!--.//container-->
    </section>  
    <!-- FAQ’S section End -->
 
     
    <!-- Footer and Script List --> 
    <?php $folder='root'; include_once('includes/footer.inc.php'); ?>
    
</body>
</html>

 
